/*****************************************************************************\
|*
|*  COPYRIGHT:     Copyright (c) 2004, Altium
|*
|*  DESCRIPTION:   VDU Text routines
|*
\*****************************************************************************/

//..............................................................................
#include "wb_vdu.h"
#include "io_wb_vdu.h"
//..............................................................................

//..............................................................................
unsigned char CaretPosX = 0;
unsigned char CaretPosY = 0;
//..............................................................................

//..............................................................................
unsigned char vdu_get_caret_pos_x ( void )
{
    return CaretPosX;
}
//..............................................................................

//..............................................................................
void vdu_set_caret_pos_x ( unsigned char x)
{
    CaretPosX = x;
}
//..............................................................................

//..............................................................................
unsigned char vdu_get_caret_pos_y ( void )
{
    return CaretPosY;
}
//..............................................................................

//..............................................................................
void vdu_set_caret_pos_y ( unsigned char y)
{
    CaretPosY = y;
}
//..............................................................................

//..............................................................................
void vdu_write_char(unsigned char chr)
{
    if (chr < 32 || chr > 126)
        chr = 32;

    vdu_set(CaretPosX,CaretPosY,chr);
}
//..............................................................................

//..............................................................................
void vdu_put_char(char ch)
{
   switch (ch)
   {
      case '\b' : if (CaretPosX == 0)
                  {
                     if (CaretPosY > 0)
                     {
                         CaretPosX = VDU_WIDTH - 1;
                         CaretPosY--;
                     }
                  }
                  else
                  {
                       CaretPosX--;
                  }
                  break;

      case '\n' : CaretPosX = 0;
                  if (CaretPosY >= VDU_HEIGHT-1)
                     vdu_vertical_scroll(1);
                  else
                     CaretPosY++;
                  break;

      case '\r' : CaretPosX = 0;
                  break;

      case '\f' : CaretPosX = 0;
                  CaretPosY = 0;
                  vdu_clear_screen();
                  break;

      default   : vdu_write_char(ch);
                  if (CaretPosX >= VDU_WIDTH - 1)
                  {
                     if (CaretPosY >= VDU_HEIGHT - 1)
                     {
                         vdu_vertical_scroll(1);
                         CaretPosX = 0;
                     }
                     else
                     {
                         CaretPosY++;
                     }
                  }
                  else
                  {
                     CaretPosX++;
                  }
                  break;
   }
}
//..............................................................................

//..............................................................................
int vdu_write(const char * buf, int size )
{
    while ( size > 0 )
    {
       vdu_put_char(*buf);
       buf++;
       size--;
    }
    return size;
}
//..............................................................................

